$(document).on("mobileinit", function () {
    $.extend($.mobile, {
        ajaxEnabled: false,
        pushStateEnabled: false,
        ignoreContentEnabled: true
    });

    $.extend($.mobile.textinput.prototype.options, {
        autogrow: false
    });
    // is supported only for this version take on consideration on upgrade
    $.mobile.filterable.prototype.options.filterCallback = function (index, searchValue) {
        var $context = this.closest("[data-questiontype='autocomplete']");
        var searchOption = $("input[type=hidden]", $context).attr("data-searchoption");
        var result = false;

    switch (searchOption) {
        case "Contains":
            result = (("" + ($.mobile.getAttribute(this, "filtertext") || $(this).text()))
                .toLowerCase().indexOf(searchValue.toLowerCase()) === -1);
            break;
        case "Exact":
            result = !(("" + ($.mobile.getAttribute(this, "filtertext") || $(this).text()))
                .toLowerCase() === searchValue.toLowerCase());
            break;
        case "StartsWith":
            result = !(("" + ($.mobile.getAttribute(this, "filtertext") || $(this).text()))
                .toLowerCase().indexOf(searchValue.toLowerCase()) === 0);
            break;
        default:
            result = (("" + ($.mobile.getAttribute(this, "filtertext") || $(this).text()))
                .toLowerCase().indexOf(searchValue.toLowerCase()) === -1);
            break;
    }
    return result;
};
});

$(document).on("pageshow", function () {
    $(".mobile").filter("[data-questiontype='text'], [data-questiontype='hybridgrid'], [data-questiontype='runningtotal'], [data-questiontype='slider']").each(function () {
        SetSideLabelsWidth($("tbody .leftLabel", $(this)));

        SetSideLabelsWidth($("tbody .rightLabel", $(this)));
    });

    //Resize header Image in this divs
    var ResizeClasses = ["div.pageHeader", "div.pageFooter"];

    for (var i = 0; i < ResizeClasses.length; i++) {
        $($(ResizeClasses[i])[0]).find("img").each(function (index, imgElement) {
            ResizeHeaderImage($(this));
        });
    }

    window.onresize = function (event) {
        for (var i = 0; i < ResizeClasses.length; i++) {
            $($(ResizeClasses[i])[0]).find("img").each(function (index, imgElement) {
                ResizeHeaderImage($(this));
            });
        }
    };
});
function ResizeHeaderImage(Imageresize) {
    var maxWidth = 100; // Max width for the image in percentage
    var maxHeight = 25;    // Max height for the image in percentage
    var ratio = 0;
    var width = Imageresize.width();
    var height = Imageresize.height();
    var theImage = new Image();
    theImage.src = Imageresize[0].src;

    // Check if current height is larger than max
    // or  Check if current height is less than max and the page are bigger
    if (((Imageresize.height() / window.innerHeight) * 100) > maxHeight
        || (((Imageresize.height() / window.innerHeight) * 100) < maxHeight && Imageresize.height() < theImage.naturalHeight)) {
        ratio = (window.innerHeight * maxHeight / 100) / height; // get ratio for scaling image

        width = width * ratio; // Reset width to match scaled image    
        Imageresize.css("max-height", (window.innerHeight * maxHeight / 100) + "px");   // Set new height
        Imageresize.css("max-width", width + "px");    // Scale width based on ratio

    }
}


function ToggleOpenEndMobile(input, singleChoice, container) {
    if (container == null || container.length == 0) {
        container = $(input).closest(".questionContainer");
    }

    var openEnd = $(".openEnd[data-choiceid='" + input.attr("id") + "']", container);
    var hasHidden = openEnd.hasClass("openEndHidden");
    var isChecked = input.is(":checked");

    if (singleChoice) {
        $(".openEndHidden", container).hide();
        $(".openEnd", container).prop("disabled", true);
    }

    if (openEnd.length > 0) {
        if (hasHidden) {
            openEnd.toggle(isChecked);
        }

        if (isChecked) {
            openEnd.textinput("enable");
        }
        else {
            openEnd.textinput("disable");
        }
    }
}

function SetSideLabelsWidth(labels) {
    if (labels.length > 0) {
        var span = $("<span />");
        var maxWidth = 0;

        $("body").append(span);

        labels.each(function () {
            span.html($(this).html());
            maxWidth = Math.max(span.width(), maxWidth);
        });

        span.remove();

        label.width(Math.max(maxWidth, maxWidth));
    }
}
